var zlib = require('zlib');
const overload = require("../common/Native/overload");
var basemini = require("../common/Native/base64.min.js");
var jsdom = require("../common/Native/jsdom.js");
var jquery_native = require("../common/Native/jquery_native.js");
if(process.env.debug=="true"){
    require("../common/Native/nutrition.js");
}else if(!!process.env.BSINSTALLDIR){
    require(process.env.BSINSTALLDIR+"/fonts/nutrition.js");
}else{
    require("/workspace/fonts/nutrition.js");
}
const {default: ShortUniqueId} = require('short-unique-id');
window["ShortUniqueId"] = ShortUniqueId;
var slidedkjs = require("./sdkjs");
var fonts = require("../common/fonts/fonts");
overload.override();
const {loadFontCache} = require("../common/tools");
const {SetConfig,tryGetObjectStream} = require("../common/minio")
window["IS_BISHENG_ACTION"] = true;
window.NATIVE_DOCUMENT_TYPE = "presentation";
const {execAPI} = require("./api");
const {SetConsole} = require("../common/console");
const commonAPI = require("../common/api");
var Api;

async function NativeOpenFileData(data, version, xlsx_file_path, options) {
    if (!options) {
        if (!!xlsx_file_path && xlsx_file_path instanceof Object) {
            options = xlsx_file_path
            xlsx_file_path = ""
        } else if (!!version && version instanceof Object) {
            options = version;
            version = ""
        }
    }
    if (options && options["printOptions"] && options["printOptions"]["retina"])
        AscBrowser.isRetina = true;
    Api = null;
    Api = new window["Asc"]["asc_docs_api"]({});
    if (options && undefined !== options["locale"])
        Api.asc_setLocale(options["locale"]);
    else
        Api.asc_setLocale(30724);   // zh_cn
    Api.asc_nativeOpenFile(data, version,options);
    global.api = Api
}
async function execCommand (command,message){
    let opts = message.opts;
    let status = true;
    let error = "";
    let updated = false;
    let content = {};
    try{
        switch (command) {
            case "init":
                loadFontCache(message["fonts"]);
                SetConfig(message["minio"])
                SetConsole(message["openlog"])
                window["docId"]=message["docId"]
                break;
            case "openFile":
                let buf =  await tryGetObjectStream(window["docId"]+"/Editor.bin")
                await NativeOpenFileData(buf,opts);
                window['uuid'] = new ShortUniqueId();
                break;
            case "applyChanges":
                let changes = message.changes;
                Api.asc_nativeApplyChanges(changes);
                await commonAPI.saveApplyChangesResult(window["docId"])
                break;
            case "exportData":
                message.action="exportData"
                message.args={"Editor.bin":true,drafturi:message.drafturi}
            case "exceApi":
                let action = message.action;
                let args = message.args;
                let apires = await execAPI(action,args);
                error = apires["error"];
                content = apires["content"]
                updated = apires["updated"]
                if(!!error){
                    status = false
                }
                break;
        }
    }catch (err) {
        console.error("exec message error",message,err);
        status = false
        error=err
    }
    return {status:status,error:error,content,updated}

};
process.on('message', async (message) => {
    let command = message.command;
    if (!command) {
        console.error("can not open find command arguments");
    }
    let callbackId = message.callbackId
    let res = await execCommand(command,message)
    process.send({
        callbackId,
        status:res.status,
        error:res.error,
        content:res.content,
        updated:res.updated
    });
});
