var zlib = require('zlib');
var commonAPI = require("../common/api");
const {putGzipObjectStream,copyObject} = require("../common/minio")
module.exports.execAPI = async (action,args)=>{
    try{
        switch (action) {
            case "bishengAction":
                let res1 = doBiShentAction(args);
                return res1;
                break;
            case "query":
                let res2 = doBiShentAction(args);
                return res2;
                break;
            case "exportData":
                let exportedData = await exportData(args)
                return exportedData;
            case "getCellsInfo":
                let cells = await queryCellsInfo(args)
                return cells;
            case "getRowsData":
                let rows = await getRowsData(args)
                return rows;
            case "insertContent":
                let ins = insertContent(args)
                return ins;
            case "setContent":
                let ins2 = setContent(args)
                return ins2;
            case "getRowsDataByIds":
                let rowData = await getRowsDataByIds(args)
                return rowData;
            case "getRowsDefinedIds":
                let rowIds = await getRowsDefinedIds(args)
                return rowIds;
            case "getSheetData":
                let data = getSheetData(args);
                return data;
            case "updateComments":
                let updateCommentsRes = await commonAPI.updateComments(args);
                return updateCommentsRes
            case "print":
                let print = await printExcel(args)
                return print;
            case "mergeRange":
                let merge = await mergeRange(args)
                return merge;
            default:
                return {"error":"Not Found"};
        }
    }catch (err) {
        console.error("exec api error ",action,args,err)
        return {"error":err}
    }
};

let doBiShentAction = (data)=>{
    let api = global.api;
    if(!api || !api["nativeApplyBishengAction"]){
        console.error("can not exec api nativeApplyBishengAction");
        return {status:"error",content:"can not find api nativeApplyBishengAction"};
    }
    let content =  api["nativeApplyBishengAction"](data);
    return {content,updated:true}
};
let queryCellsInfo = async (data)=>{
    let api = global.api;
    if(!api ||!api["bs_getCellInfo"]){
        console.error("can not exec api bs_getCellInfo");
        return {status:"error",content:"can not find api bs_getCellInfo"};
    }
    try{
        let sheet =  data["sheet"];
        let rowstart = parseInt(data["r1"]);
        let rowsend = parseInt(data["r2"]);
        let colstart = parseInt(data["c1"]);
        let colend = parseInt(data["c2"]);
        let cells = {};
        for(let r=rowstart;r<=rowsend;r++){
            for(let c= colstart;c<=colend;c++){
                let cell = await getCellInfo(sheet,r,c);
                if(cell){
                    let name = cell["name"]
                    cells[name] = cell;
                }
            }
        }
        return {content: cells};
    }catch (err) {
        console.error("exec api error ",err)
        return {status:"error",content:"exec api  get cells info error",error:err};
    }
}
let getCellInfo = (sheet,r,c)=>{
    let api = global.api;
    return new  Promise((resolve,reject)=>{
        api.bs_getCellInfo(sheet, r, c, (cell) => {
            if(cell){
                resolve(cell);
            }
        });
    })
}
let insertContent = (args)=>{
    let api = global.api;
    let content =  api.insertContent(args);
    return {content,updated:true}
}
let setContent = (args)=>{
    let api = global.api;
    let content =  api.setContent(args);
    return {content,updated:true}
}
let mergeRange = (args)=>{
    let api = global.api;
    let ranges = api.api_getRanges(args.rangeList);
    api.asc_mergeCells(args.type,{sheet:args.sheet,ranges:ranges});
    return {updated:true}
}
// let  doQuery = (data)=>{
//     let api = global.api;
//     if(!api || !api["nativeAction_query"]){
//         console.error("can not exec api nativeApplyBishengAction");
//         return {status:"error",content:"can not find api nativeApplyBishengAction"};
//     }
//     let content =  api["nativeAction_query"](data);
//     return {content}
// };
let exportData = async (data)=>{
    console.log("export excel data",data,window["docId"])
    let api = global.api;
    let content = {};
    let actions = data["actions"];
    let overwritedraft = false
    if(actions){
        if(actions["removeComments"]){
            window["BISHENG_EXPORT_NO_COMMENTS"] = true;
            overwritedraft = true;
        }
        if(actions["removeFormula"]){
            window["BISHENG_EXPORT_NO_FORMULA"] = true;
            overwritedraft = true;
        }
    }

    let start = Date.now()
    try{
        if(data["Editor.bin"]){
            let buffer = api.asc_nativeGetFileData();
            let draftUri = data["drafturi"]||window["docId"]+"/temp/Editor.bin";
            if(overwritedraft){
                draftUri = window["docId"]+"/Editor.bin"
            }
            let buf = zlib.gzipSync(buffer);
            await putGzipObjectStream(draftUri,buf)
            content["Editor.bin"]= draftUri ;
        }
    }catch (err){
        console.error("export editor.bin error",err);
        delete window["BISHENG_EXPORT_NO_COMMENTS"]
        delete window["BISHENG_EXPORT_NO_FORMULA"]
        return {content,"error":err}
    }
    try{
        if(data["Canvas.mini.bin"]!=undefined){
            let pages = parseInt(data["Canvas.mini.bin"])
            api.asc_nativeCalculateFile(true);
            let buffer =  api.asc_nativeGetPDF({
                "printOptions": {
                    "onlyActiveSheet": true,    // boolean
                    "onlyFirstPage": true,      // boolean
                    "isFullRange": true,        // boolean
                    "forceScale": true,         // boolean
                },
                "spreadsheetLayout": {
                    "ignorePrintArea": true,    // boolean
                    "orientation": "portrait",        // "portrait", "landscape"

                    "fitToWidth": null,         // number
                    "fitToHeight": null,        // number

                    "scale": null,              // number
                    "headings": true,           // boolean
                    "gridLines": true,          // boolean
                    "horizontalCentered": false, // boolean
                    "verticalCentered": false,   // boolean

                    "pageSize": {
                        "width": "1920px",          // number unit, %,px,in,cm,mm,pt,pc
                        "height": "1080px",         // number unit, %,px,in,cm,mm,pt,pc
                    },
                    "margins": {
                        "left": "0px",           // number unit, %,px,in,cm,mm,pt,pc
                        "right": "0px",          // number unit, %,px,in,cm,mm,pt,pc
                        "top": "0px",            // number unit, %,px,in,cm,mm,pt,pc
                        "bottom": "0px",         // number unit, %,px,in,cm,mm,pt,pc
                    }
                }
            });
            let uri = window["docId"]+"/temp/Canvas.mini.bin"
            let buf = zlib.gzipSync(buffer);
            await putGzipObjectStream(uri,buf)
            content["Canvas.mini.bin"] = uri ;
        }
        if(data["Canvas.bin"]){
            api.asc_nativeCalculateFile();
            let buffer =  api.asc_nativeGetPDF()
            let uri = window["docId"]+"/temp/Canvas.bin"
            let buf = zlib.gzipSync(buffer);
            await putGzipObjectStream(uri,buf)
            content["Canvas.bin"] = uri ;
        }
        if(data["Csv"] ){
            if(!content["Editor.bin"]){
                let buffer = api.asc_nativeGetFileData();
                let buf = zlib.gzipSync(buffer);
                let uri = window["docId"]+"/Editor.bin"
                await putGzipObjectStream(uri,buf)
                content["Editor.bin"] = uri ;
            }
            content["Csv"]=true;
        }
        if(data["Reports"]){
            content["Reports"] = api["nativeAction_query"](data["Reports"])
        }
    }catch (err){
        console.error("export layout data error",err);
    }
    delete window["BISHENG_EXPORT_NO_COMMENTS"]
    delete window["BISHENG_EXPORT_NO_FORMULA"]
    console.warn("export data time:",window['docId'],Date.now()-start)
    return {content}
}
let getRowsData = function (data){
    let api = global.api;
    if(!api ||!api["bs_getRows"]){
        console.error("can not exec api bs_getCellInfo");
        return {status:"error",content:"can not find api bs_getCellInfo"};
    }
    try{
        return new  Promise((resolve,reject)=>{
            api.bs_getRows(data,(rows)=>{
                resolve({content: rows});
            });
        })
    }catch (err){
        console.error("get rows data error",err)
    }
}
let getRowsDataByIds = function (data){
    let api = global.api;
    if(!api ||!api["bs_getRowsValueByNames"]){
        console.error("can not exec api bs_getRowsValueByNames");
        return {status:"error",content:"can not find api bs_getRowsValueByNames"};
    }
    try{
        return new  Promise((resolve,reject)=>{
            api.bs_getRowsValueByNames(data,(row)=>{
                resolve({content: row});
            });
        })
    }catch (err){
        console.error("get rows data error",err)
    }
}
let getRowsDefinedIds = function (datas){
    let api = global.api;
    if(!api ||!api["getRowsDefinedIds"]){
        console.error("can not exec api getRowsDefinedIds");
        return {status:"error",content:"can not find api getRowsDefinedIds"};
    }
    try{
        return new  Promise((resolve,reject)=>{
            let ret = [];
            for (let i = 0; i < datas.length; ++i) {
                let data = datas[i];
                let rowIds = api.getRowsDefinedIds(data.sheet, data.rowsIndexes);
                ret.push(rowIds);
            }
            let changes = api["bs_exportChanges"]();
            resolve({content: ret,updated:true,changes});
        })
    }catch (err){
        console.error("get rows data error",err)
    }
}
let getSheetData = function (args){
    let api = global.api;
    if(!api ||!api["bs_getSheetData"]){
        console.error("can not exec api bs_getCellInfo");
        return {status:"error",content:"can not find api bs_getSheetData"};
    }
    try{
        let data =  api.bs_getSheetData(args);
        return {content: data}
    }catch (err){
        console.error("get rows data error",err)
    }
}
let printExcel = async (args)=>{
    let api = global.api;
    let content = {};
    api.asc_nativeCalculateFile(true);
    let buffer =  api.asc_serverPrint(args);
    let uri = window["docId"]+"/temp/Canvas.bin"
    let buf = zlib.gzipSync(buffer);
    await putGzipObjectStream(uri,buf)
    content["Canvas.bin"] = uri ;
    return {content}
}
