var zlib = require('zlib');
const overload = require("../common/Native/overload");
var basemini = require("../common/Native/base64.min.js");
var jsdom = require("../common/Native/jsdom.js");
var jquery_native = require("../common/Native/jquery_native.js");
// var  xregexp = require("../common/Native/xregexp-all-min.js");
if(process.env.debug=="true"){
    require("../common/Native/nutrition.js");
}else if(!!process.env.BSINSTALLDIR){
    require(process.env.BSINSTALLDIR+"/fonts/nutrition.js");
}else{
    require("/workspace/fonts/nutrition.js");
}
const {default: ShortUniqueId} = require('short-unique-id');
window["ShortUniqueId"] = ShortUniqueId;
var cellsdkjs = require("./sdkjs");
var fonts = require("../common/fonts/fonts");
const {execAPI} = require("./api");
const {loadFontCache} = require("../common/tools")
const {SetConfig,tryGetObjectStream} = require("../common/minio")
const {SetConsole} = require("../common/console");
const commonAPI = require("../common/api");
overload.override();
window["IS_BISHENG_ACTION"] = true;
window.NATIVE_DOCUMENT_TYPE = "spreadsheet";
var Api;

async function NativeOpenFileData(data, version, xlsx_file_path, options) {
    if (!options) {
        if (!!xlsx_file_path && xlsx_file_path instanceof Object) {
            options = xlsx_file_path
            xlsx_file_path = ""
        } else if (!!version && version instanceof Object) {
            options = version;
            version = ""
        }
    }
    if (options && options["printOptions"] && options["printOptions"]["retina"])
        AscBrowser.isRetina = true;
    Api = null;
    Api = new window["Asc"]["spreadsheet_api"]({});
    if (options && undefined !== options["locale"])
        Api.asc_setLocale(options["locale"]);
    else
        Api.asc_setLocale(30724);   // zh_cn
    await Api.asc_nativeOpenFile(data, version, undefined, xlsx_file_path);
    Api.onDocumentContentReady();
    global.api = Api
}
async function execCommand (command,message){
    if (!command) {
        console.error("can not open find command arguments");
    }
    let opts = message.opts;
    let status = true;
    let updated = false;
    let error = "";
    let content = {};
    try{
        let ot = Date.now()
        switch (command) {
            case "init":
                loadFontCache(message["fonts"]);
                SetConfig(message["minio"])
                SetConsole(message["openlog"])
                window["docId"]=message["docId"]
                console.warn("exec command ",command,window["docId"], Date.now()-ot)
                break;
            case "openFile":
                let buf =  await tryGetObjectStream(window["docId"]+"/Editor.bin")
                await NativeOpenFileData(buf,opts);
                window['uuid'] = new ShortUniqueId();
                console.warn("exec command ",command,window["docId"], Date.now()-ot)
                break;
            case "applyChanges":
                let changes = message.changes;
                Api.asc_nativeApplyChanges(changes);
                // console.warn("exec command ",command,window["docId"])
                await commonAPI.saveApplyChangesResult(window["docId"])
                break;
            case "exportData":
                message.action="exportData"
                message.args={"Editor.bin":true,drafturi:message.drafturi}
            case "exceApi":
                let action = message.action;
                let args = message.args;
                let apires = await execAPI(action,args);
                error = apires["error"];
                content = apires["content"]
                updated = apires["updated"]
                if(!!error){
                    status = false
                }
                // console.warn("exec api ", command,action,window["docId"])
                break;
        }
    }catch (err) {
        console.error("exec message error",message,err,);
        status = false
        error=err
    }
    return {status:status,error:error,content,updated}

};
process.on('message', async (message) => {
    let command = message.command;
    if (!command) {
        console.error("can not open find command arguments");
    }
    let callbackId = message.callbackId
    let res = await execCommand(command,message)
    process.send({
        callbackId,
        status:res.status,
        error:res.error,
        content:res.content,
        updated:res.updated
    });
});
