
var zlib = require('zlib');
var Readable = require('stream').Readable;
var  Minio = require("docs.minio")
var  connection
var config = {}
var opts = {}
module.exports.SetConfig = function (_config){
    connection =  new Minio.Client(_config.opts);
    config=_config.config;
    opts = _config.opts
}
let getBucket = function (bucketType="draft"){
    let res ="";
    if(bucketType=="static"){
        res = config.staticbucket;
    }else if(bucketType=="draft"){
        res = config.draftbucket;
    }else if(bucketType=="upload"){
        res = bucketType.uploadbucket
    }
    if (res==""){
        console.error("can not find the bucket")
        res = bucketType;
    }
    return res;
}
module.exports.tryGetObjectStream = async (storageURI,bucket= "draft")=>{
    try{
        let gzipRes = await getGzipObjectStream(storageURI,bucket)
        return gzipRes;
    }catch (err){
        console.warn("get gzip stream error",err)
        let unzipRes = await getObjectStream(storageURI,bucket)
        return unzipRes;
    }
}


let getObjectStream = async (storageURI,bucket= "draft")=>{
    bucket = getBucket(bucket);
    return new Promise((resolve,reject)=>{
        connection.getObject(bucket, storageURI, function(err, dataStream) {
            if (err) {
                reject(err);
                return;
            }
            var bufs = [];
            dataStream
                .on('data', function (chunk) {
                    bufs.push(chunk);
                })
                .on('end', function () {
                    resolve(Buffer.concat(bufs));
                })
                .on('error', function (err) {
                    console.error(err);
                    reject(err)
                })

        })
    })
}
let getGzipObjectStream = async (storageURI,bucket= "draft")=>{
    bucket = getBucket(bucket);
    return new Promise((resolve,reject)=>{
        connection.getObject(bucket, storageURI, function(err, dataStream) {
            if (err) {
                reject(err);
                return;
            }
            var bufs = [];
            dataStream.pipe(zlib.createGunzip())
                .on('data', function (chunk) {
                    bufs.push(chunk);
                })
                .on('end', function () {
                    resolve(Buffer.concat(bufs));
                })
                .on('error', function (err) {
                    console.error(err);
                    reject(err)
                })

        })
    })
};
module.exports.putGzipObjectStream = async (storageURI,stream,bucket= "draft")=>{
    var metaData = {
        'Content-Type': 'application/octet-stream',
        'Content-Encoding':'gzip'
    };
    bucket = getBucket(bucket);
    return new Promise((resolve,reject)=>{
        connection.putObject(bucket, storageURI, stream, stream.length,metaData, function(err, etag) {
            if(err){
                console.error("put gzip stream error",storageURI,err)
                reject(err)
            }else{
                // console.info("put stream success,",storageURI,etag)
                resolve(etag)
            }
        })
    })
};
module.exports.putObjectStream = async (storageURI, buffer, bucket = "draft") => {
    bucket = getBucket(bucket);
    return new Promise((resolve, reject) => {
        connection.putObject(bucket, storageURI, buffer, function (err, etag) {
            if (err) {
                console.error("put object stream error",err)
                reject(err);
            } else {
                resolve(etag);
            }
        });
    });
};
module.exports.copyObject= async (source,target,bucket)=>{
    bucket = getBucket(bucket);
    let conds = new Minio.CopyConditions();
    target= target;
    if(!opts.dnsLookup){
        source = "/"+bucket+"/"+source;
    }
    return new Promise((resolve, reject) => {
        try{
            connection.copyObject(bucket, target,source,conds, function (e) {
                if (e) {
                    console.error("copy object error -1",e,source,target)
                    reject(e)
                } else {
                    resolve(true)
                }
            })
        }catch (err){
            console.error("copy object error -2",err,source,target)
            reject(e)
        }
    });
};
