const {parentPort,isMainThread} = require("worker_threads");
var zlib = require('zlib');
const overload = require("../common/Native/overload");
var basemini = require("../common/Native/base64.min.js");
var jsdom = require("../common/Native/jsdom.js");
var jquery_native = require("../common/Native/jquery_native.js");
if(process.env.debug=="true"){
    require("../common/Native/nutrition.js");
}else{
    require("/workspace/fonts/nutrition.js");
}
const {default: ShortUniqueId} = require('short-unique-id');
window["ShortUniqueId"] = ShortUniqueId;
var slidedkjs = require("./sdkjs");
var fonts = require("../common/fonts/fonts");
overload.override();
const {loadFontCache} = require("../common/tools");
window["IS_BISHENG_ACTION"] = true;
window.NATIVE_DOCUMENT_TYPE = "presentation";
window['cdnhost']=""
const {execAPI} = require("./api");
var Api;

async function NativeOpenFileData(data, version, xlsx_file_path, options) {
    if (!options) {
        if (!!xlsx_file_path && xlsx_file_path instanceof Object) {
            options = xlsx_file_path
            xlsx_file_path = ""
        } else if (!!version && version instanceof Object) {
            options = version;
            version = ""
        }
    }
    if (options && options["printOptions"] && options["printOptions"]["retina"])
        AscBrowser.isRetina = true;
    Api = null;
    Api = new window["Asc"]["asc_docs_api"]({});
    Api.asc_setLocale(30724);   // zh_cn
    Api.asc_nativeOpenFile(data, version,options);
    global.api = Api
}
parentPort.on("message", async (message) => {
    let command = message.command;
    if (!command) {
        console.error("can not open find command arguments");
    }
    let content;
    let status = true;
    let isbuffer = false;
    let buffers =[];
    try{
        switch (command) {
            case "init":
                loadFontCache(message["fonts"]);
                break;
            case "openFile":
                await NativeOpenFileData(message.data);
                window['uuid'] = new ShortUniqueId();
                break;
            case "applyChanges":
                let changes = message.changes;
                Api.asc_nativeApplyChanges(changes);
                break;
            case "exportData":
                let buffer = Api.asc_nativeGetFileData();
                content = {"Editor.bin":zlib.gzipSync(buffer)};
                buffers.push(content["Editor.bin"].buffer)
                isbuffer = true;
                break;
            case "exportChanges":
                break;
            case "exceApi":
                let action = message.action;
                let args = message.args;
                let apires = await execAPI(action,args);
                error = apires["error"];
                if(apires["content"]){
                    isbuffer = true;
                    if(apires["buffers"]){
                        for(let key in apires["buffers"]){
                            buffers.push(apires["content"][key].buffer)
                        }
                        apires["content"]["buffers"] = apires["buffers"];
                        content = apires["content"];
                    }else{
                        content  = Buffer.from(JSON.stringify(apires["content"]));
                        buffers.push(content.buffer)
                    }

                }
                updated = apires["updated"];
                if(apires["changes"]){
                    isbuffer = true;
                    outchanges  = Buffer.from(JSON.stringify(apires["changes"]));
                    buffers.push(outchanges.buffer)
                }
                break;
        }
    }catch (err) {
        console.error("exec message error",message,err);
        status = false
    }
    if(isbuffer){
        parentPort.postMessage({callbackId:message.callbackId,status,content},buffers)
    }else{
        parentPort.postMessage({callbackId:message.callbackId,status,content})
    }

});
