var zlib = require('zlib');
var commonAPI = require("../common/api");
const {putGzipObjectStream,putObjectStream} = require("../common/minio")
module.exports.execAPI = async (action,args)=>{
    try{
        switch (action) {
            case "bishengAction":
                let res1 = await doBiShengAction(args);
                return res1;
                break;
            case "query":
                let res2 = doQuery(args);
                return res2;
            case "insertDoc":
                let res3 = await doInertDoc(args)
                return res3
            case "exportData":
                let exportedData = await exportData(args)
                return exportedData;
            case "updateComments":
                let updateCommentsRes = await commonAPI.updateComments(args);
                return updateCommentsRes
            case "modifyWithTrackchange":
                let modifyres = await modifyWithTrackchange(args)
                return modifyres
            case "layoutState":
                let layout = await queryLayoutState(args)
                return layout
            case "getDocOutline":
                let outline = await getDocOutline();
                return outline;
            case "getDocParasInfo":
                let parasInfo = await getDocParasInfo();
                return parasInfo;
            case "setDocParasInfo":
                return await setDocParasInfo(args);
            case "getDocPageInfo":
                let pageInfo = await getDocPageInfo();
                return pageInfo;
            case "setDocPageInfo":
                return await setDocPageInfo(args);
            default:
                return {"error":"Not Found"};
        }
    }catch (err) {
        console.error("exec api error ",err)
        return {"error":err}
    }
};

let doBiShengAction = async (data)=> {
    let api = global.api;
    if(!api || !api["nativeApplyBishengAction"]){
        console.error("can not exec api nativeApplyBishengAction");
        return {status:"error",content:"can not find api nativeApplyBishengAction"};
    }
    try{
        api["bs_TurnOffInterfaceAction"]();
        let closeTrackChange = data["closeTrackChange"]
        if(closeTrackChange){
            api.asc_SetTrackRevisions(false);
        }
        let res =  await api["nativeApplyBishengAction"](data);
        return {updated:true}
    }catch (err){
        console.error("bisheng action error",err,data)
        return {updated:true}
    }

};
let  doQuery = (data)=>{
    let api = global.api;
    if(!api || !api["nativeAction_query"]){
        console.error("can not exec api nativeApplyBishengAction");
        return {status:"error",content:"can not find api nativeAction_query"};
    }
    let content =  api["nativeAction_query"](data);
    return {content}
};
let doInertDoc = async (data) =>{
    let objectType = data["type"];
    let position = data["position"];
    let draft = data["content"];
    let newPage = data["newPage"]
    if(!api || !api["nativeApplyInsertDoc"]){
        console.error("can not exec api nativeApplyBishengAction");
        return {status:"error",content:"can not find api nativeApplyInsertDoc"};
    }
    api["bs_TurnOffInterfaceAction"]();
    await api["nativeApplyInsertDoc"](draft,objectType,position,newPage);
    return {updated:true}
}
let exportData = async (data)=>{
    let api = global.api;
    let content = {};
    let actions = data["actions"];
    let updated = false;
    let overwritedraft = false
    if(actions){
        if (actions["applyChanges"]){
            api.asc_AcceptAllChanges();
            overwritedraft = true;
            updated = true;
        }else if(actions["rejectChanges"]){
            api.asc_RejectAllChanges();
            overwritedraft = true;
            updated = true;
        }
        if(actions["removeComments"]){
            api.asc_RemoveAllComments();
            overwritedraft = true;
            updated = true;
        }
        if(actions["removeBookmarks"]){
            api.asc_RemoveAllBookmarks();
            overwritedraft = true;
            updated = true;
        }
        if(actions["addWaterMark"]){
            console.info("export pdf with watermark",data["watermark"])
        }
    }
    try{
        if(data["Editor.bin"]){
            let buffer = api.asc_nativeGetFileData();
            let draftUri = data["drafturi"]||window["docId"]+"/temp/Editor.bin";
            if(overwritedraft){
                draftUri = window["docId"]+"/Editor.bin"
            }
            let buf = zlib.gzipSync(buffer);
            await putGzipObjectStream(draftUri,buf)
            content["Editor.bin"]= draftUri ;
        }
    }catch (err){
        console.error("export editor.bin error",err);
        return {content,"error":err}
    }
    try{
        if(data["Canvas.mini.bin"]!=undefined){
            let pages = parseInt(data["Canvas.mini.bin"])
            api.asc_nativeCalculateFile(pages);
            let buffer =  api.asc_nativeGetPDF({"toPageIndex": pages})
            let uri = window["docId"]+"/temp/Canvas.mini.bin"
            let buf = zlib.gzipSync(buffer);
            await putGzipObjectStream(uri,buf)
            content["Canvas.mini.bin"] = uri ;
        }
        if(data["Canvas.bin"]){
            let openGzip = true;
            if(actions&&actions["disableWatermark"]){
                window["BSWaterMarkCFG"] = {}
            }else{
                window["BSWaterMarkCFG"] = paresWatermarkOpts(data["watermark"])
            }
            // if(!window["BSWaterMarkCFG"] || Object.keys(window["BSWaterMarkCFG"])==0){
            //     openGzip = true
            // }
            api.asc_BeginViewModeInReview(true);
            api.asc_nativeCalculateFile();
            let buffer =  api.asc_nativeGetPDF()
            api.asc_EndViewModeInReview();
            let uri = window["docId"]+"/temp/Canvas.bin"
            let buf = buffer;
            if(openGzip){
                buf=zlib.gzipSync(buffer);
                await putGzipObjectStream(uri,buf)
            }else{
                await putObjectStream(uri,buf)
            }
            content["Canvas.bin"] = uri ;
            delete window["BSWaterMarkCFG"];
        }
        if(data["Html"]&& api.asc_nativeGetHtml){
            content["Html"] = api["asc_nativeGetHtml"]()
        }
        if(data["Text"] &&  api.asc_GetTextContent){
            content["Text"] = api["asc_GetTextContent"]()
        }
        if(data["Reports"]){
            content["Reports"] = api["nativeAction_query"](data["Reports"])
        }
    }catch(err){
        console.error("export layout data error",err);
    }
    return {content,updated}

}
let defaultImageLogo = "data:image/png;base64,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"
let paresWatermarkOpts = (wobj)=>{
    let defaultWatermarkCfg = {
        "Alpha": 0.2,
        "FontSize": "16pt",
        "FontName": "微软雅黑",
        "Color_r": "255",       // 0 ~ 255
        "Color_g": "0",         // 0 ~ 255
        "Color_b": "0",         // 0 ~ 255
        "Italic": false,
        "Bold": false,
        "SmallCap": false,
        "OffsetX": 50,
        "OffsetY": -50,
        "BlockWidth": 300,
        "BlockHeight": 200,
        "Rotate": -45,
        "Text": "毕升Office",  //毕升office
        "Text2": "2018~2021", //Since 2018~2021
        "LineGapX": 20,
        "LineGapY": 20,
        "Images": [
            {
                "Image": defaultImageLogo,
                "ImageWidth": 240,   // 仅在服务器端有效，客户端会自动探测
                "ImageHeight": 240,  // 仅在服务器端有效，客户端会自动探测
                "ImagePosType": "center",     // "absolute", "center"
                "ImageScale": 2,
                "ImageLeft": undefined,    // only valid if ImagePos = "absolute"
                "ImageRight": undefined,     // only valid if ImagePos = "absolute"
                "ImageTop": undefined,    // only valid if ImagePos = "absolute"
                "ImageBottom": undefined     // only valid if ImagePos = "absolute"
            },
            {
                "Image": defaultImageLogo,
                "ImageWidth": 240,   // 仅在服务器端有效，客户端会自动探测
                "ImageHeight": 240,  // 仅在服务器端有效，客户端会自动探测
                "ImagePosType": "absolute",     // "absolute", "center"
                "ImageScale": 0.25,
                "ImageLeft": undefined,    // only valid if ImagePos = "absolute"
                "ImageRight": 10,     // only valid if ImagePos = "absolute"
                "ImageTop": 10,    // only valid if ImagePos = "absolute"
                "ImageBottom": undefined     // only valid if ImagePos = "absolute"
            }
        ]
    }
    if(!wobj || Object.keys(wobj).length==0){
        return;
    }
    if(!wobj["isDefault"] && !wobj["text"] && !wobj["text2"] && (!wobj["images"] || wobj["images"].length==0)){
        return ;
    }
    if(wobj.alpha!=undefined){
        defaultWatermarkCfg["Alpha"] = wobj.alpha
    }
    if(!!wobj["fontSize"]){
        defaultWatermarkCfg["FontSize"] = parseInt(wobj["fontSize"])+"pt"
    }
    if(!!wobj["fontName"]){
        defaultWatermarkCfg["FontName"] = wobj["fontName"]
    }
    if(!!wobj["color"]){
        defaultWatermarkCfg["Color_r"] = wobj["color_r"]||0
        defaultWatermarkCfg["Color_g"] = wobj["color_g"]||0
        defaultWatermarkCfg["Color_b"] = wobj["color_b"]||0
    }

    if(!!wobj["italic"]){
        defaultWatermarkCfg["Italic"] =wobj["italic"]
    }
    if(!!wobj["bold"]){
        defaultWatermarkCfg["Bold"] =wobj["bold"]
    }
    if(!!wobj["width"]){
        defaultWatermarkCfg["BlockWidth"] =wobj["width"]
    }
    if(!!wobj["height"]){
        defaultWatermarkCfg["BlockHeight"] =wobj["height"]
    }
    if(!!wobj["offsetX"]){
        defaultWatermarkCfg["OffsetX"] =wobj["offsetX"]
    }
    if(!!wobj["offsetY"]){
        defaultWatermarkCfg["OffsetY"] =wobj["offsetY"]
    }
    if(!!wobj["rotate"]){
        defaultWatermarkCfg["Rotate"] =wobj["rotate"]
    }
    if(!!wobj["text"]){
        defaultWatermarkCfg["Text"] =wobj["text"]
    }else if (!wobj["isDefault"]){
        defaultWatermarkCfg["Text"]="";
    }
    if(!!wobj["text2"]){
        defaultWatermarkCfg["Text2"] =wobj["text2"]
    }else if (!wobj["isDefault"]){
        defaultWatermarkCfg["Text2"]="";
    }
    if(!!wobj["images"] && wobj["images"].length>0){
        defaultWatermarkCfg["Images"] = wobj["images"];
    }else if (!wobj["isDefault"]){
        defaultWatermarkCfg["Images"]=[];
    }
    return defaultWatermarkCfg;
}

let createTempUser  = (user)=>{
    if(!user){
        return null;
    }
    let apiUser = new Asc.asc_CUserInfo();
    apiUser.asc_putId(user["userId"])
    apiUser.asc_putFullName(user["userName"])
    return apiUser
}
let modifyWithTrackchange = async (data)=>{
    if(data instanceof  Array){
        var dataobj = {"data":data}
        data = dataobj;
    }
    let update = data["data"]
    if(!update || update.length==0){
        return {updated:false}
    }
    let api = global.api;
    let brMg = api.asc_GetBookmarksManager();
    if(!brMg){
        return {updated:false}
    }
    let oldUser = api.asc_backupUserInfo();
    let apiUser = new Asc.asc_CUserInfo();
    if(data["user"]){
        let user = data["user"];
        apiUser.asc_putId(user["userId"])
        apiUser.asc_putFullName(user["userName"])
        api.asc_updateUserInfo(apiUser)
    }else{
        apiUser = oldUser
    }

    let bookmarkRecords = [];
    let bookmarksMap = {};
    let bookmarkIdPrefix = "_bstag_";
    if (data["closeTrackchange"]) {
        api.asc_SetTrackRevisions(data["closeTrackchange"] === false);
    } else {
        // 默认打开trackchange
        api.asc_SetTrackRevisions(true);
    }
    api.asc_nativeCalculateFile();
    for(let i=0;i< update.length;i++){
        let ac = update[i];
        let startPoint = ac["start"]
        let startPara = startPoint["paraId"];
        let startIndex = startPoint["index"];
        let endPara = startPara;
        let endIndex = startIndex
        let endPoint = ac["end"];
        if(!endPoint ){
            let length = 0;
            if(!!ac["length"]){
                length = ac["length"]
            }
            endIndex = startIndex+length
        }else{
            endPara = endPoint["paraId"]
            endIndex = endPoint["index"]
        }
        let brId =  bookmarkIdPrefix+startPara+"_"+startIndex+"_"+endPara+"_"+endIndex
        if(!bookmarksMap[brId]){
            api.bs_SelectTextByPos(startPara,startIndex,endPara,endIndex)
            if (brMg) {
                brMg.asc_AddBookmark(brId);
                let br = {brId:brId,actions:[]}
                bookmarksMap[brId]=br;
                bookmarkRecords.push(brId)
            }
        }
        if(bookmarksMap[brId]){
            bookmarksMap[brId].actions.push(ac)
        }
    }
    for(let i=0;i<bookmarkRecords.length;i++){
        let brId = bookmarkRecords[i];
        let acs = bookmarksMap[brId].actions
        for(let j =0;j<acs.length;j++){
            let ac = acs[j];
            if(ac["action"]=="delTxt"){
                api["Add_Text"]("",brId)
                brMg.asc_RemoveBookmark(brId);
            }
            if(ac["action"]=="addTxt"){
                api["Add_Text"](ac["content"], brId);
                brMg.asc_RemoveBookmark(brId);
            }
            if(ac["action"]=="setStyle"){
                api["Set_Style"](ac["content"], brId);
                brMg.asc_RemoveBookmark(brId);
            }
            if(ac["action"]=="addComment"){
                brMg.asc_SelectBookmark(brId)
                commonAPI.addComment(ac["content"],createTempUser(ac["user"])||apiUser,ac["time"])
                brMg.asc_RemoveBookmark(brId);
            }
        }
    }
    api.asc_updateUserInfo(oldUser)
    updated = true;
    if(api["bs_exportChanges"]){
        let changes = api["bs_exportChanges"]();
        if(!changes || !changes["changes"]||changes["changes"].length<1){
            updated = false
        }
        return {updated,changes}
    }else{
        return {updated}
    }
}
let queryLayoutState = async (data)=>{
    let api = global.api;
    if(!api || !api["bs_GetLayoutState"]){
        console.error("can not exec api nativeApplyBishengAction");
        return {status:"error",content:"can not find api nativeAction_query"};
    }
    api.asc_nativeCalculateFile();
    let content =  api["bs_GetLayoutState"]();
    return {content}
}
let getDocOutline = async ()=>{
    let api = global.api;
    if(!api || !api["bs_getDocumentOutline"]){
        console.error("can not exec api bs_getDocumentOutline");
        return {status:"error",content:"can not find api bs_getDocumentOutline"};
    }
    let content = api["bs_getDocumentOutline"]()
    return {content};
}
let getDocParasInfo = async ()=>{
    let api = global.api;
    if(!api || !api["asc_GetParagraphsInfo"]){
        console.error("can not exec api asc_GetParagraphsInfo");
        return {status:"error",content:"can not find api asc_GetParagraphsInfo"};
    }
    let content = api["asc_GetParagraphsInfo"]()
    return {content};
}
let setDocParasInfo = async (args)=>{
    let api = global.api;
    if(!api || !api["bs_setParagraphProp"]){
        console.error("can not exec api bs_setParagraphProp");
        return {status:"error",content:"can not find api bs_setParagraphProp"};
    }
    let paraId = args['paraId'];
    let dataArray = args['data'];
    if (!paraId || !dataArray || !(dataArray instanceof  Array)) {
        console.error("bs_setParagraphProp gets wrong params");
        return;
    }
    api.asc_SetTrackRevisions(args["closeTrackchange"] === false);
    api["bs_setParagraphProp"](paraId, dataArray);
    return {updated:true};
}
let getDocPageInfo = async ()=>{
    let api = global.api;
    if(!api || !api["bs_getPageInfo"]){
        console.error("can not exec api bs_getPageInfo");
        return {status:"error",content:"can not find api bs_getPageInfo"};
    }
    let content = api["bs_getPageInfo"]()
    return {content};
}
let setDocPageInfo = async (args)=>{
    let api = global.api;
    if(!api || !api["bs_setPageInfo"]){
        console.error("can not exec api bs_setPageInfo");
        return {status:"error",content:"can not find api bs_setPageInfo"};
    }
    api["bs_setPageInfo"](args);
    return {updated:true};
}