var zlib = require('zlib');
const overload = require("../common/Native/overload");
require("../common/Native/base64.min.js");
require("../common/Native/jsdom.js");
require("../common/Native/jquery_native.js");
if(process.env.NODE_ENV != 'production'){
    require("../common/Native/nutrition.js");
}else{
    require("/workspace/fonts/nutrition.js");
}
const {fontsCache} = require("../common/preload-tools")
const {loadFontCache} = require("../common/tools")
loadFontCache(fontsCache)
const {default: ShortUniqueId} = require('short-unique-id');
window["ShortUniqueId"] = ShortUniqueId;
require("./sdkjs");
require("../common/fonts/fonts");
overload.override();
window["IS_BISHENG_ACTION"] = true;
window.NATIVE_DOCUMENT_TYPE = "document";
var Api;
var translate = {
    "Series": "系列",
    "Diagram Title": "图表标题",
    "X Axis": "X轴",
    "Y Axis": "Y轴",
    "Your text here": "单击此处输入文字",
    "No table of contents entries found.": "未找到目录项。",
    "Header": "页眉",
    "Footer": "页脚",
    "Table of Contents": "目录",
    "First Page ": "首页",
    "Even Page ": "偶数页",
    "Odd Page ": "奇数页",
    "Normal": "正常",
    "No Spacing": "无空格",
    "Heading 1": "标题1",
    "Heading 2": "标题2",
    "Heading 3": "标题3",
    "Heading 4": "标题4",
    "Heading 5": "标题5",
    "Heading 6": "标题6",
    "Heading 7": "标题7",
    "Heading 8": "标题8",
    "Heading 9": "标题9",
    "Title": "标题",
    "Subtitle": "副标题",
    "Quote": "引用",
    "Intense Quote": "直接引用",
    "List Paragraph": "排列段落",
    "footnote text": "Footnote Text"
}
async function NativeOpenFileData(data, version, options) {
    if (!options) {
        if (!!version && version instanceof Object) {
            options = version;
            version = ""
        }
    }
    if (options && options["printOptions"] && options["printOptions"]["retina"])
        AscBrowser.isRetina = true;
    // window.NATIVE_DOCUMENT_TYPE = window.native.GetEditorType();
    Api = null;
    Api = new window["Asc"]["asc_docs_api"]({translate:translate});
    Api.asc_nativeOpenFile(data, version,options);
    global.api = Api
    window["defaultSdtText"] =["你的文本在此","单击此处输入文字","    年  月  日","插入数字","输入非空内容"].concat(options.defaultSdtText||[])
}
//请确保参数中包含有水印配置
let processWatermark = async (data)=>{
    let api = global.api;
    let content = {};
    let noCompress =!!data["noCompress"]
    api.asc_nativeCalculateFile();

    if(data["image"]){
        api.bs_insertImageWatermark(data["image"])
    }else if(data['text']){
        api.bs_insertTextWatermark(data["text"])
    }
    if(data["Editor.bin"]){
        let buffer = api.asc_nativeGetFileData();
        if(!noCompress){
            buffer =  zlib.gzipSync(buffer);
        }
        content["Editor.bin"] = buffer ;
    }
    return content
}
//var images="data:image/png;base64,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"
var fs = require("fs")
var path = require("path")
var originEditorData=  process.argv[2];//"/Users/dan/docs/temp/watermark/Editor.bin"
var outputpath = process.argv[3]; //"/Users/dan/docs/temp/watermark/temp"
var args = {"Editor.bin":true,"text":"毕升Office@2018~2021",image:"",noCompress:true}
var argsstr = process.argv[4];
if( !!argsstr){
    let buff = new Buffer(argsstr, 'base64');
    argsstr = buff.toString()
    args = JSON.parse(argsstr)
}else{
    console.info("default argument")
}
// console.info("watermark ",originEditorData,outputpath,args)
var data = fs.readFileSync(originEditorData);
NativeOpenFileData(data,{docId:"preload_word",title:"abc.docx",fileType:"word"}).then(async ()=>{
    var res = await processWatermark(args)
    if(res["Editor.bin"]){
        fs.unlinkSync(originEditorData)
        fs.writeFileSync(path.join(outputpath,"input.bin"),res["Editor.bin"])
    }
}).catch(err=>{
    console.error(err)
})
