const fs = require("fs");
const path = require("path");

const { createBundleRenderer } = require('vue-server-renderer');

var Apps = [
    {
        app: "document",
        docType:"docx",
        mode:"edit",
    },
    {
        app: "spreadsheet",
        docType: "xlsx",
        mode:"edit",
    },
    {
        app: "presentation",
        docType: "pptx",
        mode:"edit",
    },
    {
        app: "document",
        docType:"docx",
        mode:"view",
    },
    {
        app: "spreadsheet",
        docType: "xlsx",
        mode:"view",
    },
    {
        app: "presentation",
        docType: "pptx",
        mode:"view",
    }
];

const isDev = process.env.NODE_ENV !== 'production'
const outPut = (isDev ? "debug":"build");
const bundleJsonPath = path.join(__dirname,`../${outPut}`);
const resolve = file => path.resolve(__dirname, file)
const buildpath =  process.argv[2] ||bundleJsonPath
const outputPath = process.argv[3]||`../../view/editor`;
const configpath = process.argv[4];
const uitemplate = process.argv[5];
const opts =  process.argv[7];
const langs = ["zh","en","ko"];
if(opts){
    let buff = new Buffer(opts, 'base64');
    let argsstr = buff.toString();
    let args = JSON.parse(argsstr)
    let _langs =args["lang"]||[]
    for(let i=0;i< _langs.length;i++){
        if(langs.indexOf(_langs[i])<0){
            langs.push(_langs[i])
        }
    }
}
global['_serverRuntime'] = true;

var  defaultJSON = {};
if (!!configpath && fs.existsSync(configpath)){
    defaultJSON = JSON.parse(fs.readFileSync(configpath))
}
console.info("build args ",buildpath,outputPath,configpath,uitemplate)
var renderApp = function (App,lang,callback){
    global['_defaultBuildLang'] = lang
    const app = App.app;
    const mode = App.mode
    const docType = App.docType
    global['menuLang']  ={}
    const bundleJsonPath = path.join(buildpath,`${app}-server-bundle.json`)  ;
    const menuPath =  path.join(buildpath,`${app}/static/i18n/${global['_defaultBuildLang']}.json`)  ;
    const templatePath =   path.join(buildpath,`${app}/${app}.html`);
    const outputTemplate = path.join(outputPath,`${app}_${mode}_${lang}.tmpl`)
    const bundle = require(bundleJsonPath);
    if(!fs.existsSync(menuPath)){
        console.error("can not  find menu lang",menuPath)
    }else{
        global['menuLang'] = JSON.parse(fs.readFileSync(resolve(menuPath),"utf-8"))
    }
    if(!fs.existsSync(menuPath)){
        console.error("can not  find menu lang",menuPath)
    }else{
        global['menuLang'] = JSON.parse(fs.readFileSync(resolve(menuPath),"utf-8"))
    }
    const renderer = createBundleRenderer(
        bundle,
        {
            runInNewContext: false,
            template: fs.readFileSync(resolve(templatePath), "utf-8"),
        }
    );

    let size = getInitSize(defaultJSON,mode)
    const context = {
        title: '{{.title}}', // default title
        icon: '{{.icon}}',
        docType: docType,
        docSuffix: "{{.fileSuffix}}",
        docId: "{{.docId}}", //document id //use a local id
        fileId: "{{.fileId}}",
        args: "{{.default}}",
        fonts: "{{.fonts}}",
        fontsList: "{{.fontsList}}",
        uriprefix: "{{.uriprefix}}",
        fontsVersion:"{{.fontsVersion}}",
        cdnhost: "{{.cdnhost}}",
        fontsConfig:"{{.fontsConfig}}",
        jsConfig:'',
        dataUrl: "{{.dataUrl}}",
        preload: "{{.preload}}",
        watermark: "{{.watermark}}",
        barHeight:size.h,
        barWidth:size.w,
        menuLang:menuLang,
        viewMode:mode=="view"
    }
    global.window = global;
    window["uiconfig"] ={ui:defaultJSON,isOfficeViewer:mode=="view"};
    global.location = {href:""};
    global.docType = docType;//todo: for 'doc'
    global.Asc = {};
    const s = Date.now()
    renderer.renderToString(context, (err, html) => {
        if (err) {
            console.error("render error", App,err,html);
            callback();
            return;
        }
        html = html.replace(/<!---->/g,'{{safe "<!---->"}}')
        html = '{{ define "editor/'+app+"_"+mode+"_"+lang+'.tmpl" }}\r\n'+html + '{{ end }}'
        if(fs.existsSync(outputTemplate)){
            fs.unlinkSync(outputTemplate)
        }
        fs.writeFileSync(outputTemplate,html)
        console.log(`whole request: ${docType} ${mode} ${Date.now() - s}ms`)
        callback();
    })
}



var templateJSON = [];
if (!!uitemplate && fs.existsSync(uitemplate)){
    templateJSON = JSON.parse(fs.readFileSync(uitemplate))
}

var renderTemplateJSON = function (template,lang,mode,callback){
    global['_defaultBuildLang'] = lang
    let type = template["type"]
    let app = "document"
    // const mode = "edit"
    if(type=="xlsx"){
        app = "spreadsheet"
    }else if(type=="pptx"){
        app = "presentation"
    }
    let tid = template["tid"];


    const bundleJsonPath = path.join(buildpath,`${app}-server-bundle.json`)  ;
    const templatePath =   path.join(buildpath,`${app}/${app}.html`);
    const menuPath =  path.join(buildpath,`${app}/static/i18n/${global['_defaultBuildLang']}.json`)  ;
    const outputTemplate = path.join(outputPath,`${app}_${mode}_${tid}_${lang}.tmpl`)
    const bundle = require(bundleJsonPath);

    if(!fs.existsSync(menuPath)){
        console.error("can not  find menu lang",menuPath)
    }else{
        global['menuLang'] = JSON.parse(fs.readFileSync(resolve(menuPath),"utf-8"))
    }
    const renderer = createBundleRenderer(
        bundle,
        {
            runInNewContext: false,
            template: fs.readFileSync(resolve(templatePath), "utf-8"),
        }
    );
    let size = getInitSize(template,mode)
    const context = {
        title: '{{.title}}', // default title
        icon: '{{.icon}}',
        docType: type,
        docSuffix: "{{.fileSuffix}}",
        docId: "{{.docId}}", //document id //use a local id
        fileId: "{{.fileId}}",
        args: "{{.default}}",
        fonts: "{{.fonts}}",
        fontsList: "{{.fontsList}}",
        uriprefix: "{{.uriprefix}}",
        fontsVersion:"{{.fontsVersion}}",
        cdnhost: "{{.cdnhost}}",
        fontsConfig:"{{.fontsConfig}}",
        jsConfig:'',
        dataUrl: "{{.dataUrl}}",
        preload: "{{.preload}}",
        watermark: "{{.watermark}}",
        barHeight:size.h,
        barWidth:size.w,
        viewMode:mode=="view"
    }
    global.window = global;
    window["uiconfig"] ={ui:template};
    global.location = {href:""};
    global.docType = type;//todo: for 'doc'
    global.Asc = {};
    const s = Date.now()
    renderer.renderToString(context, (err, html) => {
        if (err) {
            console.error("render error", err);
            callback();
            return;
        }
        html = html.replace(/<!---->/g,'{{safe "<!---->"}}')
        html = '{{ define "editor/'+app+"_"+mode+"_"+tid+"_"+lang+'.tmpl" }}\r\n'+html + '{{ end }}'
        if(fs.existsSync(outputTemplate)){
            fs.unlinkSync(outputTemplate)
        }
        fs.writeFileSync(outputTemplate,html)
        console.log(`whole request:${tid} ${Date.now() - s}ms`)
        callback();
    })
}
function generateMobileTemplate(){
    const bundleJsonPath = path.join(buildpath,"mobile");
    const docType=["document","spreadsheet","presentation"];
    for(let i=0;i<docType.length;i++){
        const app = docType[i];
        const html = path.join(bundleJsonPath,app+".html");
        const outputTemplate = path.join(outputPath,`${app}_mobile.tmpl`)
        if(fs.existsSync(html)){
            let htmlstr = fs.readFileSync(html);
            htmlstr = '{{ define "editor/'+app+'_mobile.tmpl" }}\r\n'+htmlstr + '{{ end }}'
            if(fs.existsSync(outputTemplate)){
                fs.unlinkSync(outputTemplate)
            }
            fs.writeFileSync(outputTemplate,htmlstr)
        }else {
            console.error("can not load mobile html template",html)
        }
    }

}
function getInitSize(config,mode){
    let barHeight = 120;
    let barWidth = 60;
    if( mode=="view" ) {
        barHeight = 46;
        barWidth=0
        if(config["define_ribbon"]){
            barHeight -= 46;
        }
    }else if( config["hide_toolbar"]){
        barHeight = 0;
    }
    else{
        if(config["define_ribbon"]){
            barHeight -= 46;
        }
        if( config["collapse_toolbar"]){
            barHeight -= 74;
        }
    }

    if (config["disable_right_menu"]){
        barWidth =0;
    }
    let ui = config["right_menu"];
    if(ui && ui.disable){
        barWidth =0;
    }

    return {h:barHeight,w:barWidth}
}

var foreachApp = function (lang,callback){
    const app = Apps.pop();
    if(app){
        renderApp(app,lang,()=>{
            foreachApp(lang,callback)
        })
    }else{
        callback&&callback();
    }
}
var foreachTemplateJSON = function (lang,callback){
    const template = templateJSON.pop();
    if(template){
        renderTemplateJSON(template,lang,"edit",()=>{
            renderTemplateJSON(template,lang,"view",()=>{
                foreachTemplateJSON(lang,callback)
            })
        })
    }else{
        callback&&callback();
    }
}
generateMobileTemplate();

var copyApp = Apps.concat([])
var copyTempateJSON = templateJSON.concat([])

var foreachLang = function (){
    const lang = langs.pop();
    if(lang){
        Apps = copyApp.concat([])
        templateJSON = copyTempateJSON.concat([])
        foreachApp(lang,()=>{
            foreachTemplateJSON(lang,()=>{
                foreachLang()
            })
        })
    }else{
        console.info("finish render")
    }
}
foreachLang()

