var zlib = require('zlib');
const overload = require("../common/Native/overload");
require("../common/Native/base64.min.js");
require("../common/Native/jsdom.js");
require("../common/Native/jquery_native.js");
// require("../common/Native/xregexp-all-min.js");
if(!!process.env.BSINSTALLDIR){
    require(process.env.BSINSTALLDIR+"/fonts/nutrition.js");
}else if(process.env.NODE_ENV != 'production'){
    require("../common/Native/nutrition.js");
}else{
    require("/workspace/fonts/nutrition.js");
}
const {fontsCache} = require("../common/preload-tools")
const {loadFontCache} = require("../common/tools")
loadFontCache(fontsCache)
const {default: ShortUniqueId} = require('short-unique-id');
window["ShortUniqueId"] = ShortUniqueId;
require("./sdkjs");
require("../common/fonts/fonts");
overload.override();
window["IS_BISHENG_ACTION"] = true;
window["raw_draft"]=true;
window["sync_load_sheet"] = true;
window.NATIVE_DOCUMENT_TYPE = "spreadsheet";
var Api;





async function NativeOpenFileData(data, version, xlsx_file_path, options) {
    if (!options) {
        if (!!xlsx_file_path && xlsx_file_path instanceof Object) {
            options = xlsx_file_path
            xlsx_file_path = ""
        } else if (!!version && version instanceof Object) {
            options = version;
            version = ""
        }
    }
    if (options && options["printOptions"] && options["printOptions"]["retina"])
        AscBrowser.isRetina = true;
    Api = null;
    Api = new window["Asc"]["spreadsheet_api"]({});
    if (options && undefined !== options["locale"])
        Api.asc_setLocale(options["locale"]);
    else
        Api.asc_setLocale(30724);

    await Api.asc_nativeOpenFile(data, version, undefined, xlsx_file_path);
    Api.onDocumentContentReady();
    global.api = Api
}
let exportData = async (data)=>{
    let api = global.api;
    let content = {};
    let actions = data["actions"];
    if(actions){
        if(actions["removeComments"]){
            window["BISHENG_EXPORT_NO_COMMENTS"] = true;
        }
        if(actions["removeFormula"]){
            window["BISHENG_EXPORT_NO_FORMULA"] = true;
        }
    }
    let noCompress =!!data["noCompress"]
    if(data["Editor.bin"]||data["Csv"]){
        let buffer = api.asc_nativeGetFileData();
        if(!noCompress){
            buffer =  zlib.gzipSync(buffer);
        }
        content["Editor.bin"] = buffer;
    }
    if(!!data["Canvas.mini.bin"] || !!data["Canvas.bin"]){
        api.asc_nativeCalculateFile(true);
    }
    if(data["Canvas.mini.bin"]!=undefined){
        let pages = parseInt(data["Canvas.mini.bin"])
        let buffer =  api.asc_nativeGetPDF({
            "printOptions": {
                "onlyActiveSheet": true,    // boolean
                "onlyFirstPage": true,      // boolean
                "isFullRange": true,        // boolean
                "forceScale": true,         // boolean
            },
            "spreadsheetLayout": {
                "ignorePrintArea": true,    // boolean
                "orientation": "portrait",        // "portrait", "landscape"

                "fitToWidth": null,         // number
                "fitToHeight": null,        // number

                "scale": null,              // number
                "headings": true,           // boolean
                "gridLines": true,          // boolean
                "horizontalCentered": false, // boolean
                "verticalCentered": false,   // boolean

                "pageSize": {
                    "width": "1920px",          // number unit, %,px,in,cm,mm,pt,pc
                    "height": "1080px",         // number unit, %,px,in,cm,mm,pt,pc
                },
                "margins": {
                    "left": "0px",           // number unit, %,px,in,cm,mm,pt,pc
                    "right": "0px",          // number unit, %,px,in,cm,mm,pt,pc
                    "top": "0px",            // number unit, %,px,in,cm,mm,pt,pc
                    "bottom": "0px",         // number unit, %,px,in,cm,mm,pt,pc
                }
            }
        });
        if(!noCompress){
            buffer =  zlib.gzipSync(buffer);
        }
        content["Canvas.mini.bin"] = buffer
    }
    if(!!data["Canvas.bin"]){
        let args = data["args"];
        let buffer =  api.asc_serverPrint(args);
        content["Canvas.bin"] = buffer
    }
    if(data["Reports"]){
        content["Reports"] = api["nativeAction_query"](data["Reports"])
    }
    return content
}

var fs = require("fs")
var path = require("path")
var originEditorData= process.argv[2];//"/Users/dan/Desktop/Editor.bin"
var outputpath = process.argv[3]; //"/Users/dan/Desktop/temp"
var data = fs.readFileSync(originEditorData);
var args = {"Editor.bin":true}
var argsstr = process.argv[4];
if( !!argsstr){
    let buff = new Buffer(argsstr, 'base64');
    argsstr = buff.toString()
    args = JSON.parse(argsstr)
}else{
    console.info("default argument")
}
NativeOpenFileData(data).then(async ()=>{
    var res = await exportData(args)
    if(res["Canvas.mini.bin"]){
        fs.writeFileSync(path.join(outputpath,"Canvas.mini.bin"),res["Canvas.mini.bin"])
    }
    if(res["Canvas.bin"]){
        fs.writeFileSync(path.join(outputpath,"Canvas.bin"),res["Canvas.bin"])
    }
    if(res["Editor.bin"]){
        fs.writeFileSync(path.join(outputpath,"Editor.bin"),res["Editor.bin"])
    }
    if(res["Reports"]){
        fs.writeFileSync(path.join(outputpath,"export.json"),res["Reports"])
    }
}).catch(err=>{
    console.error(err)
})
