var fs = require("fs")
var path = require("path")
const zlib = require("zlib");
const {putGzipObjectStream} = require("./minio");
let updateCommentContent = (id,text,user)=>{
    let api = global.api;
    let c = api.asc_findComment(id);
    if(!c){
        return;
    }
    c.asc_putText(text)
    if(user){
        c.asc_putUserId(user.userId);
        c.asc_putUserName(user.userName);
    }
    api.asc_changeComment(id,c);
}
let removeComment = (id)=>{
    let api = global.api;
    api.asc_removeComment(id)
}
let updateReply=(id,replyIndex,content,user)=>{
    let api = global.api;
    let c = api.asc_findComment(id);
    if(!c){
        return;
    }
    let reply = c.asc_getReply(replyIndex);
    if(!reply){
        return;
    }
    reply.asc_putText(content)
    if(user){
        reply.asc_putUserId(user.userId);
        reply.asc_putUserName(user.userName);
    }
    api.asc_changeComment(id,c);
}
let timeZoneOffsetInMs= (new Date()).getTimezoneOffset() * 60000
let utcDateToString = function (date){
    if (Object.prototype.toString.call(date) === '[object Date]')
        return (date.getTime() - timeZoneOffsetInMs).toString();

    return '';
}
let ooDateToString= function (date) {
    if (Object.prototype.toString.call(date) === '[object Date]')
        return (date.getTime()).toString();

    return '';
}
let buildCommentData = function  () {
    if (typeof Asc.asc_CCommentDataWord !== 'undefined') {
        return new Asc.asc_CCommentDataWord(null);
    }
    return new Asc.asc_CCommentData(null);
}
let addReply = (id,content,user)=>{
    let api = global.api;
    let c = api.asc_findComment(id,true);
    if(!c){
        return;
    }
    let addReply =  buildCommentData(null);
    addReply.asc_putText(content);
    addReply.asc_putTime(utcDateToString(new Date()));
    addReply.asc_putOnlyOfficeTime(ooDateToString(new Date()));
    if(user){
        addReply.asc_putUserId(user.userId);
        addReply.asc_putUserName(user.userName);
    }
    c.asc_addReply(addReply);
    api.asc_changeComment(id,c);
}
let removeReply = (id,replyIndex,len)=>{
    let api = global.api;
    let c = api.asc_findComment(id,true);
    if(!c){
        return;
    }
    if(len==undefined){
        len =1;
    }
    c.asc_sliceReply(replyIndex,len);
    api.asc_changeComment(id,c);
}
module.exports.updateComments = async (data)=>{
    let api = global.api;
    if(!api){
        console.error("can not exec api");
        return {status:"error",content:"can not find api "};
    }
    let updated = false;
    let actions = data["actions"];
    let user = data["user"];
    for(let i=0;i< actions.length;i++){
        let action = actions[i];
        let type = action["type"];
        let id = action["id"];
        switch (type){
            case "updateComment":
                let commentContent = action["content"];
                updateCommentContent(id,commentContent,user)
                break;
            case "updateReply":
                let replayComment =action["content"];
                let replayIdx1 = action["replayIndex"]
                updateReply(id,replayIdx1,replayComment,user)
                break;
            case "removeReply":
                let removeReplyIndex = action["replayIndex"]
                let removeLen = action["total"];
                removeReply(id,removeReplyIndex,removeLen)
                break;
            case "addReply":
                let addComment =action["content"];
                addReply(id,addComment,user)
                break;
            case "removeComment":
                removeComment(id)
                break;
        }
        updated = true;
    }
    if(api["bs_exportChanges"]){
        let changes = api["bs_exportChanges"]();
        if(!changes || !changes["changes"]||changes["changes"].length<1){
            updated = false
        }
        return {updated,changes}
    }else{
        return {updated}
    }

}

module.exports.addComment = async (content,user,time)=>{
    let currentTime = new Date();
    if(!!time) {
        let d = new Date(time)
        if (!isNaN(d.getTime())) {
            currentTime = d;
        }
    }
    var comment = buildCommentData();
    comment.asc_putText(content);
    comment.asc_putTime(utcDateToString(currentTime));
    comment.asc_putOnlyOfficeTime(ooDateToString(currentTime));
    comment.asc_putUserId(user.asc_getId());
    comment.asc_putUserName(user.asc_getFullName());
    comment.asc_putSolved(false);
    comment.asc_putDocumentFlag(false);
    let api = global.api;
    api.asc_addComment(comment);
}
module.exports.saveFile = async (fileName,data)=>{
    let tempir = process.env.tmpdir;
    let filepath = path.join(tempir,fileName);
    fs.writeFileSync(filepath,data)
    return filepath
}
module.exports.saveApplyChangesResult = async(docId) =>{
    let api = global.api;
    let buffer = api.asc_nativeGetFileData();
    let draftUri = docId+"/temp/applyChanges_"+Date.now()+".Editor.bin";
    let buf = zlib.gzipSync(buffer);
    let res = await putGzipObjectStream(draftUri,buf)
    return res;
}
