var fs = require("fs");
var path = require("path");
let fontsCache = {};
if(global["window"]['__fonts_files']){
    for( let i=0;i< global["window"]['__fonts_files'].length;i++){
        let fontFile = global["window"]['__fonts_files'][i];
        var dir = fontFile;
        if(process.env.NODE_ENV != 'production' && !process.env.BSINSTALLDIR){
            var fontFile2 = fontFile.replace("../../../../","../../../")
            dir = path.join(__dirname, fontFile2);
        }
        if(fs.existsSync(dir)){
            var fileData = fs.readFileSync(dir);
            const sharedBuffer = new SharedArrayBuffer(fileData.length);
            const sharedArray = new Uint8Array(sharedBuffer);
            for (var c = 0; c < fileData.length;c++) {
                sharedArray[c] = fileData[c];
            }
            fontsCache[fontFile] = sharedBuffer;
        }else{
            console.warn("can not load fonts ",dir)
            const sharedBuffer = new SharedArrayBuffer(0);
            fontsCache[fontFile] = sharedBuffer;
        }
    }
}

module.exports.fontsCache = fontsCache;
