var crypto = require('crypto');

let md5 = (source) => {
    return crypto.createHash('md5').update(source).digest('hex')
};
module.exports.transferSharedArrayBuffer = (arrays)=>{
    let res = {};
    for(let key in arrays){
        res[key] =  Buffer.from(arrays[key])
    }
    return res;
}
module.exports.loadFontCache = (data)=>{
    window["fontsCache"]={};
    for(let id in data){
        const sharedArray = Buffer.from(data[id],'base64');
        window["fontsCache"][id] = sharedArray;
    }
};
module.exports.initSdtValidation = (sdtMap)=>{
    window["GetValidation"] = (reg)=>{
        let id = md5(reg);
        return sdtMap[id];
    }
}