var zlib = require('zlib');
const {putGzipObjectStream} = require("../common/minio")
module.exports.execAPI = async (action,args)=>{
    try{
        switch (action) {
            case "exportData":
                let exportedData = await exportData(args)
                return exportedData;
            default:
                return {"error":"Not Found"};
        }
    }catch (err) {
        console.error("exec api error ",err)
        return {"error":err}
    }
};
let exportData = async (data)=>{
    let api = global.api;
    let content = {};
    let updated = false;
    if(data["Editor.bin"]){
        let buffer = api.asc_nativeGetFileData();
        let draftUri = data["drafturi"]||window["docId"]+"/temp/Editor.bin";
        let buf = zlib.gzipSync(buffer);
        await putGzipObjectStream(draftUri,buf)
        content["Editor.bin"]= draftUri ;
    }
    if(data["Canvas.mini.bin"]!=undefined){
        let pages = parseInt(data["Canvas.mini.bin"])
        api.asc_nativeCalculateFile(pages);
        let buffer =  api.asc_nativeGetPDF({"toPageIndex": pages})
        let uri = window["docId"]+"/temp/Canvas.mini.bin"
        let buf = zlib.gzipSync(buffer);
        await putGzipObjectStream(uri,buf)
        content["Canvas.mini.bin"] = uri ;
    }
    if(data["Canvas.bin"]){
        api.asc_nativeCalculateFile();
        let buffer =  api.asc_nativeGetPDF()
        let uri = window["docId"]+"/temp/Canvas.bin"
        let buf = zlib.gzipSync(buffer);
        await putGzipObjectStream(uri,buf)
        content["Canvas.bin"] = uri ;
    }
    return {content,updated}
}
