var zlib = require('zlib');
const overload = require("../common/Native/overload");
require("../common/Native/base64.min.js");
require("../common/Native/jsdom.js");
require("../common/Native/jquery_native.js");
if(!!process.env.BSINSTALLDIR){
    require(process.env.BSINSTALLDIR+"/fonts/nutrition.js");
}else if(process.env.NODE_ENV != 'production'){
    require("../common/Native/nutrition.js");
}else{
    require("/workspace/fonts/nutrition.js");
}
const {fontsCache} = require("../common/preload-tools")
const {loadFontCache} = require("../common/tools")
loadFontCache(fontsCache)
const {default: ShortUniqueId} = require('short-unique-id');
window["ShortUniqueId"] = ShortUniqueId;
require("./sdkjs");
require("../common/fonts/fonts");

overload.override();
window["IS_BISHENG_ACTION"] = true;
window["raw_draft"]=true;
window.NATIVE_DOCUMENT_TYPE = "presentation";

var Api;

async function NativeOpenFileData(data, version, xlsx_file_path, options) {
    if (!options) {
        if (!!xlsx_file_path && xlsx_file_path instanceof Object) {
            options = xlsx_file_path
            xlsx_file_path = ""
        } else if (!!version && version instanceof Object) {
            options = version;
            version = ""
        }
    }
    if (options && options["printOptions"] && options["printOptions"]["retina"])
        AscBrowser.isRetina = true;
    Api = null;
    Api = new window["Asc"]["asc_docs_api"]({});
    if (options && undefined !== options["locale"])
        Api.asc_setLocale(options["locale"]);
    else
        Api.asc_setLocale(30724);
    Api.asc_nativeOpenFile(data, version,options);
    global.api = Api
}
let exportData = async (data)=>{
    let api = global.api;
    let content = {};
    if(data["Editor.bin"]){
        let buffer = api.asc_nativeGetFileData();
        content["Editor.bin"] = zlib.gzipSync(buffer) ;
    }
    if(data["Canvas.mini.bin"]!=undefined){
        let pages = parseInt(data["Canvas.mini.bin"])
        api.asc_nativeCalculateFile(pages);
        let buffer =  api.asc_nativeGetPDF({"toPageIndex": pages})
        content["Canvas.mini.bin"] = zlib.gzipSync(buffer) ;
    }
    if(data["Canvas.bin"]){
        api.asc_nativeCalculateFile();
        let buffer =  api.asc_nativeGetPDF()
        content["Canvas.bin"] = zlib.gzipSync(buffer) ;
    }
    return content
}

var fs = require("fs")
var path = require("path")
var originEditorData= process.argv[2];//"/Users/dan/Desktop/Editor.bin"
var outputpath = process.argv[3]; //"/Users/dan/Desktop/temp"
var data = fs.readFileSync(originEditorData);
NativeOpenFileData(data).then(async ()=>{
    var args = {"Editor.bin":true}
    var res = await exportData(args)
    if(res["Canvas.mini.bin"]){
        fs.writeFileSync(path.join(outputpath,"Canvas.mini.bin"),res["Canvas.mini.bin"])
    }
    if(res["Editor.bin"]){
        fs.writeFileSync(path.join(outputpath,"Editor.bin"),res["Editor.bin"])
    }
    if(res["Canvas.bin"]){
        fs.writeFileSync(path.join(outputpath,"Canvas.bin"),res["Canvas.bin"])
    }

}).catch(err=>{
    console.error(err)
})
