var zlib = require('zlib');
const overload = require("../common/Native/overload");
require("../common/Native/base64.min.js");
require("../common/Native/jsdom.js");
require("../common/Native/jquery_native.js");
if(!!process.env.BSINSTALLDIR){
    require(process.env.BSINSTALLDIR+"/fonts/nutrition.js");
}else if(process.env.NODE_ENV != 'production'){
    require("../common/Native/nutrition.js");
}else{
    require("/workspace/fonts/nutrition.js");
}
const {fontsCache} = require("../common/preload-tools")
const {loadFontCache} = require("../common/tools")
loadFontCache(fontsCache)
const {default: ShortUniqueId} = require('short-unique-id');
window["ShortUniqueId"] = ShortUniqueId;
require("./sdkjs");
require("../common/fonts/fonts");
overload.override();
window["IS_BISHENG_ACTION"] = true;
window["raw_draft"]=true;
window.NATIVE_DOCUMENT_TYPE = "document";
var Api;
var translate = {
    "Series": "系列",
    "Diagram Title": "图表标题",
    "X Axis": "X轴",
    "Y Axis": "Y轴",
    "Your text here": "单击此处输入文字",
    "No table of contents entries found.": "未找到目录项。",
    "Header": "页眉",
    "Footer": "页脚",
    "Table of Contents": "目录",
    "First Page ": "首页",
    "Even Page ": "偶数页",
    "Odd Page ": "奇数页",
    "Normal": "正常",
    "No Spacing": "无空格",
    "Heading 1": "标题1",
    "Heading 2": "标题2",
    "Heading 3": "标题3",
    "Heading 4": "标题4",
    "Heading 5": "标题5",
    "Heading 6": "标题6",
    "Heading 7": "标题7",
    "Heading 8": "标题8",
    "Heading 9": "标题9",
    "Title": "标题",
    "Subtitle": "副标题",
    "Quote": "引用",
    "Intense Quote": "直接引用",
    "List Paragraph": "排列段落",
    "footnote text": "Footnote Text"
}
async function NativeOpenFileData(data, version, options) {
    if (!options) {
        if (!!version && version instanceof Object) {
            options = version;
            version = ""
        }
    }
    if (options && options["printOptions"] && options["printOptions"]["retina"])
        AscBrowser.isRetina = true;
    // window.NATIVE_DOCUMENT_TYPE = window.native.GetEditorType();
    Api = null;
    Api = new window["Asc"]["asc_docs_api"]({translate:translate});
    if (options && undefined !== options["locale"])
        Api.asc_setLocale(options["locale"]);
    else
        Api.asc_setLocale(30724);
    Api.asc_nativeOpenFile(data, version,options);
    global.api = Api
}
let exportData = async (data)=>{
    let api = global.api;
    let content = {};
    let actions = data["actions"];
    let noCompress =!!data["noCompress"]
    if(actions){
        if (actions["applyChanges"]){
            api.asc_AcceptAllChanges();
        }else if(actions["rejectChanges"]){
            api.asc_RejectAllChanges();
        }
        if(actions["removeComments"]){
            api.asc_RemoveAllComments();
        }
        if(actions["removeBookmarks"]){
            api.asc_RemoveAllBookmarks();
        }
    }
    if(data["Editor.bin"]){
        let buffer = api.asc_nativeGetFileData();
        if(!noCompress){
            buffer =  zlib.gzipSync(buffer);
        }
        content["Editor.bin"] = buffer ;
    }
    if(data["Canvas.mini.bin"]!=undefined){
        let pages = parseInt(data["Canvas.mini.bin"])
        api.asc_nativeCalculateFile(pages);
        let buffer =  api.asc_nativeGetPDF({"toPageIndex": pages})
        if(!noCompress){
            buffer = zlib.gzipSync(buffer) ;
        }
        content["Canvas.mini.bin"] = buffer
    }
    if(data["Canvas.bin"]){
        api.asc_BeginViewModeInReview(true);
        api.asc_nativeCalculateFile();
        let buffer =  api.asc_nativeGetPDF()
        api.asc_EndViewModeInReview();
        if(!noCompress){
            buffer = zlib.gzipSync(buffer) ;
        }
        content["Canvas.bin"] = buffer ;
    }
    if(data["Html"]&& api.asc_nativeGetHtml){
        content["Html"] = api["asc_nativeGetHtml"]()
    }
    if(data["Text"] &&  api.asc_GetTextContent){
        content["Text"] = api["asc_GetTextContent"]()
    }
    if(data["Reports"]){
        content["Reports"] = api["nativeAction_query"](data["Reports"])
    }
    return content
}

var fs = require("fs")
var path = require("path")
var originEditorData= process.argv[2];//"/Users/dan/Desktop/Editor.bin"
var outputpath = process.argv[3]; //"/Users/dan/Desktop/temp"
var args = {"Editor.bin":true,"Canvas.mini.bin":0}
var argsstr = process.argv[4];
if( !!argsstr){
    let buff = new Buffer(argsstr, 'base64');
    argsstr = buff.toString()
    args = JSON.parse(argsstr)
}else{
    console.info("default argument")
}
var data = fs.readFileSync(originEditorData);
// console.info("watermark ",originEditorData,outputpath,args)
NativeOpenFileData(data,{docId:"preload_word",title:"abc.docx",fileType:"word"}).then(async ()=>{
    var res = await exportData(args)
    if(res["Canvas.mini.bin"]){
        fs.writeFileSync(path.join(outputpath,"Canvas.mini.bin"),res["Canvas.mini.bin"])
    }
    if(res["Editor.bin"]){
        fs.writeFileSync(path.join(outputpath,"Editor.bin"),res["Editor.bin"])
    }
    if(res["Canvas.bin"]){
        fs.writeFileSync(path.join(outputpath,"Canvas.bin"),res["Canvas.bin"])
    }
    if(res["Html"]){
        fs.writeFileSync(path.join(outputpath,"export.html"),res["Html"])
    }
    if(res["Text"]){
        fs.writeFileSync(path.join(outputpath,"export.text"),res["Text"])
    }
    if(res["Reports"]){
        fs.writeFileSync(path.join(outputpath,"export.json"),res["Reports"])
    }
}).catch(err=>{
    console.error(err)
})
