
var zlib = require('zlib');
const overload = require("../common/Native/overload");
var basemini = require("../common/Native/base64.min.js");
var jsdom = require("../common/Native/jsdom.js");
var jquery_native = require("../common/Native/jquery_native.js");
if(process.env.debug=="true"){
    require("../common/Native/nutrition.js");
}else if(!!process.env.BSINSTALLDIR){
    require(process.env.BSINSTALLDIR+"/fonts/nutrition.js");
}else{
    require("/workspace/fonts/nutrition.js");
}
const {default: ShortUniqueId} = require('short-unique-id');
window["ShortUniqueId"] = ShortUniqueId;
var wordsdkjs = require("./sdkjs");
var fonts = require("../common/fonts/fonts");
const {execAPI} = require("./api");
const {loadFontCache,initSdtValidation} = require("../common/tools");
const {SetConfig,tryGetObjectStream} = require("../common/minio")
const {SetConsole}= require("../common/console")
const commonAPI = require("../common/api");
overload.override();
window["IS_BISHENG_ACTION"] = true;
window.NATIVE_DOCUMENT_TYPE = "document";
var Api;
var translate = {
    "Series": "系列",
    "Diagram Title": "图表标题",
    "X Axis": "X轴",
    "Y Axis": "Y轴",
    "Your text here": "单击此处输入文字",
    "No table of contents entries found.": "未找到目录项。",
    "Header": "页眉",
    "Footer": "页脚",
    "Table of Contents": "目录",
    "First Page ": "首页",
    "Even Page ": "偶数页",
    "Odd Page ": "奇数页",
    "Normal": "正常",
    "No Spacing": "无空格",
    "Heading 1": "标题1",
    "Heading 2": "标题2",
    "Heading 3": "标题3",
    "Heading 4": "标题4",
    "Heading 5": "标题5",
    "Heading 6": "标题6",
    "Heading 7": "标题7",
    "Heading 8": "标题8",
    "Heading 9": "标题9",
    "Title": "标题",
    "Subtitle": "副标题",
    "Quote": "引用",
    "Intense Quote": "直接引用",
    "List Paragraph": "排列段落",
    "footnote text": "Footnote Text"
}
async function NativeOpenFileData(data, version, options) {
    if (!options) {
        if (!!version && version instanceof Object) {
            options = version;
            version = ""
        }
    }
    if (options && options["printOptions"] && options["printOptions"]["retina"])
        AscBrowser.isRetina = true;
    // window.NATIVE_DOCUMENT_TYPE = window.native.GetEditorType();
    Api = null;
    Api = new window["Asc"]["asc_docs_api"]({translate:translate});
    Api.asc_registerCallback("documentFormatError",err=>{
        console.error("catch document format error,it will exist",options)
        process.send({callbackId:"errorReport","error":"documentFormat"})
    })
    if (options && undefined !== options["locale"])
        Api.asc_setLocale(options["locale"]);
    else
        Api.asc_setLocale(30724);
    Api.asc_nativeOpenFile(data, version,options);
    global.api = Api
    global.Api = Api
    // window['AscCommon'].g_clipboardBase.Init(Api);
    Api.asc_setCanEditComments(true);
    window['AscCommon']['InitBSCopy'](Api);
    window["defaultSdtText"] =["你的文本在此","单击此处输入文字","    年  月  日","插入数字","输入非空内容"].concat(options.defaultSdtText||[])
}
async function execCommand (command,message){
    let opts = message.opts;
    let status = true;
    let updated = false;
    let error = "";
    let content = {};
    try{
        switch (command) {
            case "init":
                loadFontCache(message["fonts"]);
                SetConfig(message["minio"])
                SetConsole(message["openlog"])
                initSdtValidation(message["sdtRegMap"])
                window["docId"]=message["docId"]
                break;
            case "openFile":
                let buf =  await tryGetObjectStream(window["docId"]+"/Editor.bin")
                await NativeOpenFileData(buf, opts);
                window['uuid'] = new ShortUniqueId();
                console.warn("exec command ",command,window["docId"])
                break;
            case "applyChanges":
                let incomingChanges = message.changes;
                Api.asc_nativeApplyChanges(incomingChanges);
                // console.warn("exec command ",command,window["docId"])
                await commonAPI.saveApplyChangesResult(window["docId"])
                break;
            case "exportData":
                message.action="exportData"
                message.args={"Editor.bin":true,"Canvas.mini.bin":0,drafturi:message.drafturi}
            case "exceApi":
                let action = message.action;
                let args = message.args;
                let apires = await execAPI(action,args);
                error = apires["error"];
                content = apires["content"]
                updated = apires["updated"]
                if(!!error){
                    status = false
                }
                // console.warn("exec api ", command,action,window["docId"])
                break;
        }
    }catch (err) {
        console.error("exec message error",err);
        status = false;
        error=err
    }
    return {status:status,error:error,content,updated}
}
// const v8 = require('v8')
// console.info(Math.round(v8.getHeapStatistics().total_available_size / 1024 / 1024) + ' MB')
process.on('message', async (message) => {
    let command = message.command;
    if (!command) {
        console.error("can not open find command arguments");
    }
    let callbackId = message.callbackId
    let res = await execCommand(command,message)
    process.send({
        callbackId,
        status:res.status,
        error:res.error,
        content:res.content,
        updated:res.updated
    });
});
