#!/usr/bin/env bash

current=$PWD
dataDir=/bisheng_data

if [ -n "$1" ] ;then
    echo "data dir $1"
    dataDir=$1
fi


echo "start install $current $dataDir"
if [ ! -d logs  ];then
  mkdir $current/logs
else
  echo dir exist
fi

if [ ! -d $dataDir  ];then
  mkdir $dataDir
else
  echo "data $dataDir dir exist"
fi
if [ ! -d $dataDir/redis  ];then
  mkdir $dataDir/redis
else
  echo "redis data dir  exist"
fi



chmod a+x supervisord
chmod a+x $current/middleware/dgraph/dgraph
chmod a+x $current/middleware/meilisearch/meilisearch
chmod a+x $current/middleware/minio/minio
chmod a+x $current/middleware/redis/redis-server

chmod a+x $current/bisheng/bin/allfontsgen
chmod a+x $current/bisheng/bin/bsdrive
chmod a+x $current/bisheng/bin/bso
chmod a+x $current/bisheng/bin/tools


sed -i "s|@installdir|$current|g" $current/middleware/redis/redis.conf
sed -i "s|@datadir|$dataDir|g" $current/middleware/redis/redis.conf
sed -i "s|@installdir|$current|g" $current/middleware/supervisor.config
sed -i "s|@datadir|$dataDir|g" $current/middleware/supervisor.config
sed -i "s|@installdir|$current|g" $current/bisheng/supervisor.config

./supervisord  -c  $current/middleware/supervisor.config -d
sleep 15s
./supervisord  -c  $current/bisheng/supervisor.config    -d
